package bodybuilder.test.usually;

import org.jdom.Element;

import bodybuilder.test.TestCaseXML;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.common.Target;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * 汎用XMLテストケースXML
 */
public class UsualTestCaseXML extends TestCaseXML {

    /**
     * ターゲット
     */
    protected Target target = null;

    /**
     * 実行するメソッド
     */
    protected Execute execute = null;

    /**
     * データベースセットアップ
     */
    protected DatabaseSetUp databaseSetUp = null;

    /**
     * 戻り値
     */
    protected Return ret = null;

    /**
     * catch
     */
    protected Catch catch_ = null;

    /**
     * データベースアサーション
     */
    protected DatabaseAssertion databaseAssertion = null;

    /////////////////////////////////////////////////////////////////
    // build method

    /**
     * テストケースXMLを構築する。
     */
    protected void build() {
        super.build();
        // ターゲットを読み込む。
        loadTarget(root);
        // 入力値を読み込む。
        Element input = JDOMUtils.getRequiredChild(root, "input");
        loadInput(input);
        // 期待値を読み込む。
        Element expected = JDOMUtils.getRequiredChild(root, "expected");
        loadExpect(expected);
    }

    /**
     * ターゲットを読み込む。
     * 
     * @param root テストケース要素
     */
    protected void loadTarget(Element root) {
        // ターゲットを取得。
        Element target = JDOMUtils.getRequiredChild(root, "target");
        this.target = new Target(target);
    }

    /**
     * 入力値を読み込む。
     * 
     * @param input 入力値要素
     */
    private void loadInput(Element input) {
        // 実行するメソッドを取得。
        Element execElem = JDOMUtils.getRequiredChild(input, "execute");
        execute = new Execute(execElem);

        // データベースセットアップを取得。
        Element databaseElem = input.getChild("database");

        if (databaseElem != null) {
            databaseSetUp = new DatabaseSetUp(databaseElem, file.getParent());
        }
    }

    /**
     * 期待値を取得する。
     * 
     * @param expected 期待値
     */
    protected void loadExpect(Element expected) {
        // 戻り値を取得。
        Element retElem = expected.getChild("return");

        if (retElem != null) {
            ret = new Return(retElem);
        }

        // catchを取得。
        Element catchElem = expected.getChild("catch");

        if (catchElem != null) {
            catch_ = new Catch(catchElem);
        }

        // データベースアサーションを取得。
        Element databaseElem = expected.getChild("database");

        if (databaseElem != null) {
            databaseAssertion = new DatabaseAssertion(databaseElem, file
                    .getParent());
        }
    }

    /////////////////////////////////////////////////////////////////
    // property

    /**
     * ターゲットを取得する。
     * 
     * @return ターゲット
     */
    public Target getTarget() {
        return target;
    }

    /**
     * 実行するメソッドを取得する。
     * 
     * @return 実行するメソッド
     */
    public Execute getExecute() {
        return execute;
    }

    /**
     * データベースセットアップを取得する。
     * 
     * @return データベースセットアップ
     */
    public DatabaseSetUp getDatabaseSetUp() {
        return databaseSetUp;
    }

    /**
     * 戻り値を取得する。
     * 
     * @return 戻り値
     */
    public Return getReturn() {
        return ret;
    }

    /**
     * catchを取得する。
     * 
     * @return catch
     */
    public Catch getCatch() {
        return catch_;
    }

    /**
     * データベースアサーションを取得する。
     * 
     * @return データベースアサーション
     */
    public DatabaseAssertion getDatabaseAssertion() {
        return databaseAssertion;
    }

}