package bodybuilder.viewer;

import java.util.Iterator;
import java.util.Set;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * セットビューア
 */
public class SetViewer extends Viewer {

    /**
     * セットの内容を出力する。
     * 
     * @param object セット
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // セットにキャスト。
        Set set = (Set) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        Iterator ite = set.iterator();

        // セットの要素を出力。
        for (int i = 0; ite.hasNext(); i++) {
            handler.print("[" + i + "]=>");
            dump(ite.next(), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}