package bodybuilder.viewer.servlet;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpSession;

import bodybuilder.util.ObjectUtils;
import bodybuilder.util.ServletObjectUtils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * セッションビューア
 */
public class SessionViewer extends Viewer {

    /**
     * セッションの内容を出力する。
     * 
     * @param object セッション
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // セッションにキャスト。
        HttpSession session = (HttpSession) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // 属性を取得。
        Map attributes = ServletObjectUtils.getSessionAttributes(session);
        Iterator attrNames = attributes.keySet().iterator();

        // 属性を出力。
        while (attrNames.hasNext()) {
            String name = (String) attrNames.next();
            handler.print("[\"" + name + "\"]=>");
            dump(session.getAttribute(name), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}