/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder.servlet;

import bodybuilder.builder.Builder;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ServletObjectsBullworker {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder(Config.isValidate());
    private static final String SERVLETCONTEXT_ELEMENT = "servletcontext";
    private static final String REQUEST_ELEMENT = "request";
    private static final String SESSION_ELEMENT = "session";
    private ServletContext servletcontext = null;
    private HttpServletRequest request = null;
    private HttpSession session = null;

    public ServletObjectsBullworker(String filename) {
        this(new File(filename));
    }

    public ServletObjectsBullworker(File file) {
        try {
            this.loadObjects(builder.build(file));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public ServletObjectsBullworker(InputStream in) {
        try {
            this.loadObjects(builder.build(in));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public ServletObjectsBullworker(Reader reader) {
        try {
            this.loadObjects(builder.build(reader));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public ServletContext getServletContext() {
        return this.servletcontext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpSession getSession() {
        return this.session;
    }

    private void loadObjects(Document doc) {
        Element session;
        Element request;
        Element root = doc.getRootElement();
        Element servletcontext = root.getChild(SERVLETCONTEXT_ELEMENT);
        if (servletcontext != null) {
            this.servletcontext = (ServletContext)Builder.build(servletcontext);
        }
        if ((request = root.getChild(REQUEST_ELEMENT)) != null) {
            this.request = (HttpServletRequest)Builder.build(request);
        }
        if ((session = root.getChild(SESSION_ELEMENT)) != null) {
            this.session = (HttpSession)Builder.build(session);
        }
    }
}

