package bodybuilder.builder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;

/**
 * マップビルダー
 */
public class MapBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "put";

    /**
     * マップを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return マップ
     */
    public Object getMuscle(Element element, Argument constructor) {
        // マップを生成。
        // デフォルトの実装はLinkedHashMapクラス。
        String type = getType(element, LinkedHashMap.class.getName());
        Map map = (Map) newObject(type, constructor);

        // <put>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <put>の値をマップに格納。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            String key = getRequiredName(child);
            Object value = getValue(child);
            map.put(key, value);
        }

        // マップを返す。
        return map;
    }

}