package bodybuilder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import org.apache.commons.codec.binary.Base64;

import bodybuilder.exception.BodyBuilderException;

/**
 * シリアライザ
 */
public class Serializer {

    /**
     * オブジェクトをシリアライズする。
     * 
     * @param obj オブジェクト
     * @return シリアライズされたテキスト
     */
    public static String serialize(Serializable obj) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            GZIPOutputStream gzipout = new GZIPOutputStream(bout);
            ObjectOutputStream objout = new ObjectOutputStream(gzipout);
            objout.writeObject(obj);
            objout.flush();
            gzipout.finish();
            return new String(Base64.encodeBase64(bout.toByteArray()));
        } catch (IOException e) {
            throw new BodyBuilderException("could not serialize object '" + obj
                    + "'.", e);
        }
    }

    /**
     * テキストをアンシリアライズする。
     * 
     * @param encoded シリアライズされたテキスト
     * @return オブジェクト
     */
    public static Object unserialize(String encoded) {
        try {
            byte[] src = Base64.decodeBase64(encoded.getBytes());
            ByteArrayInputStream bin = new ByteArrayInputStream(src);
            GZIPInputStream gzipin = new GZIPInputStream(bin, src.length);
            ObjectInputStream objin = new ObjectInputStream(gzipin);
            return objin.readObject();
        } catch (IOException e) {
            throw new BodyBuilderException("could not unserialize text '"
                    + encoded + "'.", e);
        } catch (ClassNotFoundException e) {
            throw new BodyBuilderException("could not unserialize text '"
                    + encoded + "'.", e);
        }
    }

}
