/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.usually;

import bodybuilder.builder.argument.Argument;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.common.Catch;
import bodybuilder.test.common.Execute;
import bodybuilder.test.common.Return;
import bodybuilder.test.common.Target;
import bodybuilder.test.database.DatabaseAssertion;
import bodybuilder.test.database.DatabaseSetUp;
import bodybuilder.test.usually.UsualTestCaseXML;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UsualTestCase
extends XMLTestCase {
    protected UsualTestCaseXML xml = null;

    protected void setXML(TestCaseXML xml) {
        this.xml = (UsualTestCaseXML)xml;
    }

    protected void runTest() {
        this.info("'" + this.getName() + "' is started.");
        this.debug("description is:" + Config.NL + this.xml.getDescription());
        Target target = this.xml.getTarget();
        this.debug("target is '" + target.getName() + "'.");
        DatabaseSetUp databaseSetUp = this.xml.getDatabaseSetUp();
        if (databaseSetUp != null) {
            this.debug("set up database by '" + databaseSetUp.getFile() + "'.");
            databaseSetUp.setUp();
        }
        Execute execute = this.xml.getExecute();
        String methodName = execute.getMethod();
        Argument argument = execute.getArgument();
        this.debug("invoked method is '" + methodName + "' as '" + target.getName() + "'.");
        Class clazz = ObjectUtils.getClass(target.getName());
        Method method = ObjectUtils.getMethod(clazz, methodName, argument.getClasses());
        Object object = null;
        if (!ObjectUtils.isStaticMethod(method)) {
            Argument constructor = target.getConstructor();
            object = ObjectUtils.getInstance(target.getName(), constructor.getClasses(), constructor.getArguments());
        }
        Object actualReturn = null;
        Throwable cause = null;
        try {
            actualReturn = ObjectUtils.invokeMethod(clazz, object, method, argument.getArguments());
        }
        catch (BodyBuilderException e) {
            if (!(e.getCause() instanceof InvocationTargetException)) {
                throw e;
            }
            cause = e.getCause().getCause();
            this.debug("'" + cause + "' was catched.");
        }
        this.debug("'" + method + "' was invoked.");
        Catch expectedCatch = this.xml.getCatch();
        if (expectedCatch != null && ObjectUtils.instance_of((Object)cause, expectedCatch.getType())) {
            this.debug("verify catched exception.");
            Inspector.assertObjectEquals(expectedCatch.getException(), cause);
            this.debug("catched exception value was corrected.");
        } else {
            if (expectedCatch != null) {
                throw new BodyBuilderException("unexpected exception '" + cause + "' but was '" + expectedCatch.getType() + "'.", cause);
            }
            if (cause != null) {
                throw new BodyBuilderException("unexpected exception '" + cause + "'.", cause);
            }
        }
        Return expectedReturn = this.xml.getReturn();
        if (expectedReturn != null) {
            this.debug("verify return value.");
            Inspector.assertObjectEquals(expectedReturn.getValue(), actualReturn);
            this.debug("return value was corrected.");
        }
        DatabaseAssertion databaseAssertion = this.xml.getDatabaseAssertion();
        if (databaseSetUp != null) {
            this.debug("verify database by '" + databaseAssertion.getFile() + "'.");
            databaseAssertion.assertDataSetEquals();
            this.debug("database was corrected.");
        }
        this.info("test was ended.");
    }
}

