/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import bodybuilder.exception.BodyBuilderException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class Serializer {
    public static String serialize(Serializable obj) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            GZIPOutputStream gzipout = new GZIPOutputStream(bout);
            ObjectOutputStream objout = new ObjectOutputStream(gzipout);
            objout.writeObject(obj);
            objout.flush();
            gzipout.finish();
            return new String(Base64.encodeBase64((byte[])bout.toByteArray()));
        }
        catch (IOException e) {
            throw new BodyBuilderException("could not serialize object '" + obj + "'.", e);
        }
    }

    public static Object unserialize(String encoded) {
        try {
            byte[] src = Base64.decodeBase64((byte[])encoded.getBytes());
            ByteArrayInputStream bin = new ByteArrayInputStream(src);
            GZIPInputStream gzipin = new GZIPInputStream((InputStream)bin, src.length);
            ObjectInputStream objin = new ObjectInputStream(gzipin);
            return objin.readObject();
        }
        catch (IOException e) {
            throw new BodyBuilderException("could not unserialize text '" + encoded + "'.", e);
        }
        catch (ClassNotFoundException e) {
            throw new BodyBuilderException("could not unserialize text '" + encoded + "'.", e);
        }
    }
}

