package sample.inspector;

import java.io.InputStream;

import junit.framework.AssertionFailedError;

import sample.util.SampleUtils;
import bodybuilder.builder.servlet.ServletObjectsBullworker;
import bodybuilder.inspector.Inspector;

public class Sample04 {

    public static void main(String[] args) {
        InputStream ein = SampleUtils
                .getResourceAsStream("sample/inspector/data/sample04-expected.xml");
        InputStream ain = SampleUtils
                .getResourceAsStream("sample/inspector/data/sample04-actual.xml");
        // ブルワーカを生成。
        ServletObjectsBullworker ebullworker = new ServletObjectsBullworker(ein);
        ServletObjectsBullworker abullworker = new ServletObjectsBullworker(ain);
        SampleUtils.closeInputStream(ein);
        SampleUtils.closeInputStream(ain);

        // サーブレットコンテキスト
        try {
            Object expected = ebullworker.getServletContext();
            Object actual = abullworker.getServletContext();
            Inspector.assertObjectEquals(expected, actual);
        } catch (AssertionFailedError e) {
            e.printStackTrace(System.out);
        }

        // リクエスト
        try {
            Object expected = ebullworker.getRequest();
            Object actual = abullworker.getRequest();
            Inspector.assertObjectEquals(expected, actual);
        } catch (AssertionFailedError e) {
            e.printStackTrace(System.out);
        }

        // セッション
        try {
            Object expected = ebullworker.getSession();
            Object actual = abullworker.getSession();
            Inspector.assertObjectEquals(expected, actual);
        } catch (AssertionFailedError e) {
            e.printStackTrace(System.out);
        }
    }

}