package bodybuilder.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;

/**
 * ビルダーマッピング
 */
class BuilderMapping {

    /**
     * ビルダーのマップ
     */
    private static Map builders = new HashMap();

    static {
        try {
            init();
        } catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '"
                    + BuilderMapping.class.getName() + "'.", e);
        }
    }

    /**
     * 初期化する。
     */
    private static void init() {
        // ビルダーのマップを取得。
        Map builderMap = Config.getBuilderMap();
        Iterator names = builderMap.keySet().iterator();
        // キャッシュを生成。
        Map cache = new HashMap();

        // XML要素名とビルダーのマップを作成。
        // ビルダーはシングルトン。
        while (names.hasNext()) {
            String name = (String) names.next();
            String className = (String) builderMap.get(name);
            Builder builder = (Builder) cache.get(className);

            if (builder == null) {
                builder = (Builder) ObjectUtils.getObject(className);
                cache.put(className, builder);
            }

            builders.put(name, builder);
        }
    }

    /**
     * ビルダーを取得する。
     * 
     * @param name XML要素名
     * @return ビルダー
     */
    static Builder getBuilder(String name) {
        // 要素名に紐付くビルダーを返す。
        return (Builder) builders.get(name);
    }

}