package bodybuilder.test.jsp;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import bodybuilder.util.Serializer;

/**
 * JSPリダイレクタ
 */
public class JSPRedirectorServlet extends HttpServlet {

    protected void service(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        // エンコーディングをセット。
        String encoding = this.getInitParameter("encoding");
        request.setCharacterEncoding(encoding);

        // テストケースXMLを取得。
        String encoded = request
                .getParameter(JSPTestCase.TESTCASE_XML_PARAM_NAME);
        JSPTestCaseXML xml = (JSPTestCaseXML) Serializer.unserialize(encoded);

        // オブジェクトをセットアップ。
        ServletContext application = getServletContext();
        xml.setupServletContext(application);
        xml.setupRequest(request);
        xml.setupSession(request.getSession());

        // JSPに遷移。
        RequestDispatcher dispatcher = application.getRequestDispatcher(xml
                .getPath());
        dispatcher.forward(request, response);
    }

}
