package bodybuilder.util.jdom;

import org.jdom.input.SAXBuilder;

/**
 * 拡張SAXビルダー
 */
public class ExtendedSAXBuilder extends SAXBuilder {

    /**
     * 拡張JDOMファクトリで拡張SAXビルダーを構築する。
     */
    public ExtendedSAXBuilder() {
        super();
        setFactory(new ExtendedJDOMFactory());
    }

    /**
     * 拡張JDOMファクトリで拡張SAXビルダーを構築する。
     * 
     * @param validate XMLのバリデーションの有効にするかどうかのフラグ
     */
    public ExtendedSAXBuilder(boolean validate) {
        super(validate);
        setFactory(new ExtendedJDOMFactory());
    }

    /**
     * 拡張JDOMファクトリで拡張SAXビルダーを構築する。
     * 
     * @param saxDriverClass SAXドライバクラス
     */
    public ExtendedSAXBuilder(String saxDriverClass) {
        super(saxDriverClass);
        setFactory(new ExtendedJDOMFactory());
    }

    /**
     * 拡張JDOMファクトリで拡張SAXビルダーを構築する。
     * 
     * @param saxDriverClass SAXドライバクラス
     * @param validate XMLのバリデーションの有効にするかどうかのフラグ
     */
    public ExtendedSAXBuilder(String saxDriverClass, boolean validate) {
        super(saxDriverClass, validate);
        setFactory(new ExtendedJDOMFactory());
    }

}