package sample.inspector;

import java.io.InputStream;

import junit.framework.AssertionFailedError;

import sample.util.SampleUtils;
import bodybuilder.builder.Bullworker;
import bodybuilder.inspector.Inspector;

public class Sample03 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/inspector/data/sample03.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // オブジェクトを取得。
        Object expected = bullworker.getMuscle("expected");
        Object actual = bullworker.getMuscle("actual");

        // オブジェクトを検査。
        try {
            Inspector.assertObjectEquals(expected, actual);
        } catch (AssertionFailedError e) {
            e.printStackTrace(System.out);
        }
    }

}