package sample.testtarget.dicon.component;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.dbutils.QueryRunner;

import sample.testtarget.dicon.constant.Result;
import sample.testtarget.dicon.object.Address;
import sample.testtarget.dicon.object.Return;
import sample.testtarget.dicon.object.Sysdate;
import sample.testtarget.dicon.object.impl.ReturnImpl;

/**
 * 住所録を更新する。
 * (Type3 - コンストラクタ・インジェクション)
 */
public class UpdateAddressBook_type3 {

    private Connection conn = null;

    private Sysdate sysdate = null;

    private static QueryRunner qr = new QueryRunner();

    public UpdateAddressBook_type3(Connection conn, Sysdate sysdate) {
        this.conn = conn;
        this.sysdate = sysdate;
    }

    /////////////////////////////////////////////////////////////////
    // logic

    public Return execute(Address address) throws SQLException {
        // 住所録を更新を更新。
        Object[] params = { address.getName(), address.getAge(),
                address.getSex().getValue(), address.getZipCode(),
                address.getAddress(), address.getTel(),
                sysdate.getNow().getTimestamp(), address.getId(),
                address.getUpdateDate().getTimestamp() };
        String update = "UPDATE ADDRESS_BOOK SET NAME=?, AGE=?, SEX=?, ZIP_CODE=?, ADDRESS=?, TEL=?, UPDATE_DATE=? WHERE ID=? AND UPDATE_DATE=?";
        int count = qr.update(conn, update, params);

        // 更新件数が0件の場合は失敗を返す。
        if (count < 1) {
            // 住所録の変更をロールバック。
            conn.rollback();

            // 失敗を返す。
            return new ReturnImpl(Result.FAILURE, "更新に失敗しました。");
        }

        // 住所録の変更をコミット。
        conn.commit();

        // 成功を返す。
        return new ReturnImpl(Result.SUCCESS, "更新に成功しました。");
    }

}