package bodybuilder.ant.xmltest;

import java.util.List;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;

/**
 * 拡張コマンドライン
 */
public class ExtendedCommandlineJava extends CommandlineJava {

    /////////////////////////////////////////////////////////////////
    // constant field

    /**
     * 置換用のシステムプロパティキー
     */
    private static final String REPLACE_KEY = "@"
            + ExtendedCommandlineJava.class.getName() + "@REPLACE_KEY";

    /**
     * 置換用のシステムプロパティ値
     */
    private static final String REPLACE_VALUE = "@"
            + ExtendedCommandlineJava.class.getName() + "@REPLACE_VALUE";

    /**
     * 置換用のシステムプロパティ
     */
    private static final String REPLACE_SYSPROP = "-D" + REPLACE_KEY + "="
            + REPLACE_VALUE;

    /**
     * システムプロパティのプリフィックス
     */
    private static final String PATH_PROPERTY_PREFIX = "-D"
            + XMLJUnitTask.TEST_PROP_KEY_ROOT_DIRS + "=";

    /////////////////////////////////////////////////////////////////
    // constructor

    /**
     * コンストラクタ。
     */
    public ExtendedCommandlineJava() {
        super();
        // 置換用のシステムプロパティを追加。
        Environment.Variable var = new Environment.Variable();
        var.setKey(REPLACE_KEY);
        var.setValue(REPLACE_VALUE);
        super.addSysproperty(var);
    }

    /////////////////////////////////////////////////////////////////
    // path list

    /**
     * パスリスト
     */
    private List pathList = null;

    /**
     * パスリストをセットする。
     * 
     * @param pathList パスリスト
     */
    public void setPathList(List pathList) {
        this.pathList = pathList;
    }

    /////////////////////////////////////////////////////////////////
    // commandline

    /**
     * コマンドラインを取得する。
     * 
     * return コマンドライン
     */
    public String[] getCommandline() {
        // コマンドラインを取得。
        String[] commandline = super.getCommandline();

        // パスリストが空の場合はコマンドラインをそのまま返す。
        if (pathList == null || pathList.size() < 1) {
            return commandline;
        }

        // コマンドラインのシステムプロパティを置換。
        for (int i = 0; i < commandline.length; i++) {
            if (REPLACE_SYSPROP.equals(commandline[i])) {
                commandline[i] = PATH_PROPERTY_PREFIX + pathList.remove(0);
            }
        }

        // システムプロパティを返す。
        return commandline;
    }

    /**
     * コマンドラインを記述する。
     */
    public String describeCommand() {
        return Commandline.describeCommand(super.getCommandline());
    }

}