package bodybuilder.builder.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * プロキシハンドラ
 */
class DynaBeanInvocationHandler implements InvocationHandler {

    /**
     * プロパティのマップ
     */
    private Map map = new HashMap();

    /**
     * メソッドハンドラ。
     * 
     * @param proxy プロキシ
     * @param method メソッド
     * @param args 引数
     */
    public Object invoke(Object proxy, Method method, Object[] args)
            throws Throwable {
        // メソッド名を取得。
        String methodName = method.getName();

        Object returnValue = null;

        // プロパティ名と値をマップにセット。
        // マッチしないメソッドは無視。
        if (methodName.matches("^get.+$") && (args == null || args.length == 0)) {
            returnValue = map.get(methodName.substring(3));
        } else if (methodName.matches("^is.+$")
                && (args == null || args.length == 0)) {
            returnValue = map.get(methodName.substring(2));
        } else if (methodName.matches("^set.+$")
                && (args != null && args.length == 1)) {
            map.put(methodName.substring(3), args[0]);
        }

        // getterの場合、戻り値を返す。
        return returnValue;
    }

}