package bodybuilder.builder.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * モックハンドラ
 */
class MockInvocationHandler implements InvocationHandler {

    /**
     * メソッドと戻り値のマップ
     */
    private Map returns = new HashMap();

    /**
     * メソッドハンドラ。
     * 
     * @param proxy プロキシ
     * @param method メソッド
     * @param args 引数
     */
    public Object invoke(Object proxy, Method method, Object[] args)
            throws Throwable {
        // メソッド名に紐付く戻り値を返す。
        return returns.get(method.getName());
    }

    /**
     * メソッド名と戻り値を登録する。
     * 
     * @param method メソッド名
     * @param ret 戻り値
     */
    public void regist(String method, Object ret) {
        // メソッド名と戻り値をマップにセット。
        returns.put(method, ret);
    }

}