package bodybuilder.builder.value;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import bodybuilder.exception.BodyBuilderException;

/**
 * 日付値
 */
public class DateValue extends ExtendedValue {

    /**
     * 日付のフォーマット
     */
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 日付オブジェクトを取得する。
     * 
     * @param value 拡張値
     * @return 日付オブジェクト
     */
    protected Object value(String value) {
        try {
            // 拡張値をパースして日付オブジェクトを生成。
            SimpleDateFormat format = new SimpleDateFormat(FORMAT);
            return format.parse(value);
        } catch (ParseException e) {
            throw new BodyBuilderException(
                    "cannot parse date '" + value + "'.", e);
        }
    }

}