package bodybuilder.inspector;

import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;

/**
 * 例外インスペクター
 */
public class ExceptionInspector extends Inspector {

    /**
     * 二つの例外が等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // 例外にキャスト。
        Exception expectedException = (Exception) expected;
        Exception actualException = (Exception) actual;

        // 期待する例外のインスタンスでない場合はエラー。
        if (!ObjectUtils.instance_of(actualException, expectedException
                .getClass())) {
            rethrow("'" + actualException.getClass().getName()
                    + "' was not child '"
                    + expectedException.getClass().getName() + "'", expected,
                    actual, trace);
        }

        // メッセージを検査。
        String expectedMessage = expectedException.getMessage();
        String actualMessage = actualException.getMessage();
        trace.appendKey("message");

        assertObjectEquals(expectedMessage, actualMessage, trace);

        Throwable expectedCause = expectedException.getCause();
        Throwable actualCause = actualException.getCause();

        // 原因を検査。
        if (Config.isInspectionExceptionCause()) {
            trace.appendKey("cause");
            assertObjectEquals(expectedCause, actualCause, trace);
        }
    }

}