package bodybuilder.test.database.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;

import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class YetAnotherXlsDataSet extends AbstractDataSet {
    private final ITable[] _tables;

    public YetAnotherXlsDataSet(File file) throws IOException, DataSetException {
        this(new FileInputStream(file));
    }

    public YetAnotherXlsDataSet(InputStream in) throws IOException,
            DataSetException {
        Workbook workbook;
        try {
            workbook = Workbook.getWorkbook(in);
        } catch (BiffException e) {
            // TODO メッセージを入れること。
            throw new DataSetException(e);
        }

        _tables = new ITable[workbook.getNumberOfSheets()];

        for (int i = 0; i < _tables.length; i++) {
            Sheet sheet = workbook.getSheet(i);
            _tables[i] = new YetAnotherXlsTable(sheet.getName(), sheet);
        }
    }

    // TODO 実装すること。
    //public static void write(IDataSet dataSet, OutputStream out)

    protected ITableIterator createIterator(boolean reversed)
            throws DataSetException {
        return new DefaultTableIterator(_tables, reversed);
    }

}