package bodybuilder.viewer;

import java.util.Iterator;
import java.util.Map;

import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * ビーンビューア
 */
public class BeanViewer extends Viewer {

    /**
     * ビーンの内容を出力する。
     * 
     * @param object ビーン
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // クラス名を取得。
        String name = ObjectUtils.getName(object, true);
        handler.print(name + " {");
        handler.indent();

        Map props = ExtendedPropertyUtils.getProperties(object);
        Iterator names = props.keySet().iterator();

        // プロパティを出力。
        while (names.hasNext()) {
            String propName = (String) names.next();
            Object value = props.get(propName);
            handler.print("[\"" + propName + "\"]=>");
            dump(value, handler);
        }

        handler.unindent();
        handler.print("}");
    }

}