package bodybuilder.viewer;

import java.text.SimpleDateFormat;
import java.util.Date;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * 日付型ビューア
 */
public class DateViewer extends Viewer {

    /**
     * 日付型の内容を出力する。
     * 
     * @param object 日付型
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // 日付型にキャスト。
        Date date = (Date) object;
        // フォーマッタを生成。
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        // 日付型を出力
        handler.print(ObjectUtils.getInfo(object) + " \"" + format.format(date)
                + "\"");
    }

}