/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;

public class ExceptionInspector
extends Inspector {
    public void assertEquals(Object expected, Object actual, ObjectBackTrace trace) {
        Exception expectedException = (Exception)expected;
        Exception actualException = (Exception)actual;
        if (Config.isInspectionExceptionClass() && !ObjectUtils.instance_of((Object)actualException, expectedException.getClass())) {
            ExceptionInspector.rethrow("'" + actualException.getClass().getName() + "' was not child '" + expectedException.getClass().getName() + "'", expected, actual, trace);
        }
        String expectedMessage = expectedException.getMessage();
        String actualMessage = actualException.getMessage();
        trace.appendKey("message");
        ExceptionInspector.assertObjectEquals(expectedMessage, actualMessage, trace);
        Throwable expectedCause = expectedException.getCause();
        Throwable actualCause = actualException.getCause();
        if (Config.isInspectionExceptionCause()) {
            trace.appendKey("cause");
            ExceptionInspector.assertObjectEquals(expectedCause, actualCause, trace);
        }
    }
}

