/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util.dbunit;

import java.math.BigDecimal;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;

public class JxlTable
extends AbstractTable {
    private Sheet sheet = null;
    private ITableMetaData metadata = null;

    public JxlTable(Sheet sheet) throws DataSetException {
        this.sheet = sheet;
        String sname = sheet.getName();
        Column[] columns = null;
        if (sheet.getRows() > 0) {
            Cell[] head = sheet.getRow(0);
            columns = new Column[head.length];
            for (int i = 0; i < head.length; ++i) {
                String cname = head[i].getContents();
                columns[i] = new Column(cname, DataType.UNKNOWN);
            }
        } else {
            columns = new Column[]{};
        }
        this.metadata = new DefaultTableMetaData(sname, columns);
    }

    public ITableMetaData getTableMetaData() {
        return this.metadata;
    }

    public int getRowCount() {
        return this.sheet.getRows() - 1;
    }

    public Object getValue(int rows, String cname) throws DataSetException {
        this.assertValidRowIndex(rows);
        this.assertValidColumn(cname);
        Cell[] cells = this.sheet.getRow(rows + 1);
        Cell cell = cells[this.getColumnIndex(cname)];
        CellType type = cell.getType();
        Object value = null;
        if (type == CellType.LABEL || type == CellType.STRING_FORMULA) {
            value = ((LabelCell)cell).getString();
        } else if (type == CellType.NUMBER || type == CellType.NUMBER_FORMULA) {
            value = new BigDecimal(((NumberCell)cell).getValue());
        } else if (type == CellType.DATE || type == CellType.DATE_FORMULA) {
            value = ((DateCell)cell).getDate();
        } else if (type == CellType.BOOLEAN || type == CellType.BOOLEAN_FORMULA) {
            value = new Boolean(((BooleanCell)cell).getValue());
        } else if (type == CellType.EMPTY) {
            value = null;
        } else {
            throw new DataTypeException("Unsupported type '" + type + "' at row=" + rows + ", column=" + cname);
        }
        return value;
    }
}

