package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.Bullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample08 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample08.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // 定数を含むオブジェクト
        Object array = bullworker.getMuscle("array");
        Viewer.dump(array);
        Object list = bullworker.getMuscle("list");
        Viewer.dump(list);
    }

}