package sample.builder.extension;

import org.jdom.Element;

import sample.object.UserDefined;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * ユーザ定義オブジェクトビルダー
 */
public class UserDefinedBuilder extends Builder {

    /**
     * ユーザ定義オブジェクトを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return ユーザ定義オブジェクト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // <message>を取得。
        Element messageElement = element.getChild("message");

        String message = null;

        // <message>の値を取得。
        if (messageElement != null) {
            message = JDOMUtils.getRequiredAttrValue(messageElement, "value");
        }

        // ユーザ定義オブジェクトを生成。
        UserDefined userDefined = new UserDefined(message);

        // ユーザ定義オブジェクトを返す。
        return userDefined;
    }

}