package bodybuilder.builder.argument;

import java.util.ArrayList;
import java.util.List;

import bodybuilder.util.ObjectUtils;

/**
 * 引数クラス
 */
public class Argument {

    /**
     * 引数リスト
     */
    private List arguments = new ArrayList();

    /**
     * 型リスト
     */
    private List classes = new ArrayList();

    /**
     * 引数とその型を追加する。
     * 
     * @param arg 引数
     * @param type 引数の型
     */
    void add(Object arg, String type) {
        Class clazz = null;

        // 引数の型を取得。
        if (type != null) {
            clazz = ObjectUtils.getClass(type);
        } else {
            clazz = arg.getClass();
        }

        // 引数と型をリストに追加。
        arguments.add(arg);
        classes.add(clazz);
    }

    /**
     * 引数を指定した型でまとめて追加する。
     * 
     * @param args 引数のリスト
     * @param clazz 引数の型
     */
    void addAll(List args, Class clazz) {
        // 引数をフィールドにセット。
        arguments = args;

        // 引数分、型をフィールドに追加。
        for (int i = 0; i < args.size(); i++) {
            classes.add(clazz);
        }
    }

    /**
     * 引数の配列を取得する。
     * 
     * @return 引数の配列
     */
    public Object[] getArguments() {
        return arguments.toArray();
    }

    /**
     * 型の配列を取得する。
     * 
     * @return 型の配列
     */
    public Class[] getClasses() {
        return (Class[]) classes.toArray(new Class[classes.size()]);
    }

}