package bodybuilder.inspector;

import java.lang.reflect.Array;

/**
 * 配列インスペクター
 */
public class ArrayInspector extends Inspector {

    /**
     * 二つの配列が等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // 配列の長さを検査。
        int expectedLen = Array.getLength(expected);
        assertSizeEquals(expectedLen, Array.getLength(actual), trace);

        // 配列の値を検査。
        for (int i = 0; i < expectedLen; i++) {
            trace.appendIndex(i);
            Object expectedElement = Array.get(expected, i);
            Object actualElement = Array.get(actual, i);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}