package bodybuilder.viewer;

import java.util.List;

import bodybuilder.util.ObjectUtils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * リストビューア
 */
public class ListViewer extends Viewer {

    /**
     * リストの内容を出力する。
     * 
     * @param object リスト
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // リストにキャスト。
        List list = (List) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // リストの要素を出力。
        for (int i = 0; i < list.size(); i++) {
            handler.print("[" + i + "]=>");
            dump(list.get(i), handler);
        }

        handler.unindent();
        handler.print("}");
    }

}