/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.dicon;

import bodybuilder.builder.Builder;
import bodybuilder.test.common.Execute;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.jdom.JDOMUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class InjectedObjects {
    private List names = new ArrayList();
    private Map objects = new LinkedHashMap();
    private List classes = new ArrayList();
    private Map successes = new LinkedHashMap();
    private Map failures = new LinkedHashMap();
    private Map windups = new LinkedHashMap();

    public InjectedObjects(Element component, int type) {
        List children = component.getChildren("inject");
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String name = JDOMUtils.getRequiredAttrValue(child, "name");
            String argType = JDOMUtils.getRequiredAttrValue(child, "type");
            Object object = Builder.getValue(child);
            Element successElement = child.getChild("success");
            Execute[] success = null;
            success = successElement != null ? this.getExecutes(successElement) : new Execute[]{};
            Element failureElement = child.getChild("failure");
            Execute[] failure = null;
            failure = failureElement != null ? this.getExecutes(failureElement) : new Execute[]{};
            Element windupElement = child.getChild("windup");
            Execute[] windup = null;
            windup = windupElement != null ? this.getExecutes(windupElement) : new Execute[]{};
            this.add(name, object, argType, success, failure, windup);
        }
    }

    private Execute[] getExecutes(Element elem) {
        ArrayList<Execute> executes = new ArrayList<Execute>();
        List children = elem.getChildren("exec");
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            executes.add(new Execute(child));
        }
        return executes.toArray(new Execute[executes.size()]);
    }

    private void add(String name, Object object, String type, Execute[] success, Execute[] failure, Execute[] windup) {
        Class clazz = ObjectUtils.getClass(type);
        this.names.add(name);
        this.objects.put(name, object);
        this.classes.add(clazz);
        this.successes.put(name, success);
        this.failures.put(name, failure);
        this.windups.put(name, windup);
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public Object getObject(String name) {
        return this.objects.get(name);
    }

    public Map getObjectMap() {
        return this.objects;
    }

    public Object[] getObjects() {
        return this.objects.values().toArray();
    }

    public Class[] getClasses() {
        return this.classes.toArray(new Class[this.classes.size()]);
    }

    public Execute[] getSuccess(String name) {
        return (Execute[])this.successes.get(name);
    }

    public Map getSuccesses() {
        return this.successes;
    }

    public Execute[] getFailure(String name) {
        return (Execute[])this.failures.get(name);
    }

    public Map getFailures() {
        return this.failures;
    }

    public Execute[] getWindUp(String name) {
        return (Execute[])this.windups.get(name);
    }

    public Map getWindUps() {
        return this.windups;
    }
}

