package sample.inspector.extension;

import sample.object.UserDefined;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;

/**
 * ユーザ定義オブジェクトインスペクター
 */
public class UserDefinedInspector extends Inspector {

    /**
     * 二つのユーザ定義オブジェクトが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // ユーザ定義オブジェクトを取得。
        UserDefined expectedObj = (UserDefined) expected;
        UserDefined actualObj = (UserDefined) actual;

        // メッセージを検査。
        trace.appendKey("message");
        assertObjectEquals(expectedObj.message(), actualObj.message(), trace);
    }

}