package sample.testtarget.dicon;

import java.sql.Connection;
import java.sql.SQLException;
import sample.testtarget.dicon.component.UpdateAddressBook_type2;
import sample.testtarget.dicon.component.UpdateAddressBook_type3;
import sample.testtarget.dicon.constant.Sex;
import sample.testtarget.dicon.object.Address;
import sample.testtarget.dicon.object.Return;
import sample.testtarget.dicon.object.Sysdate;
import sample.testtarget.dicon.object.impl.AddressImpl;
import sample.testtarget.dicon.object.impl.ConnectionImpl;
import sample.testtarget.dicon.object.impl.SysdateImpl;
import sample.testtarget.dicon.util.ExDate;

public class ComponentRunner {

    public static void main(String[] args) {
        try {
            type2();
            //type3();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void type2() throws SQLException {
        Connection conn = null;

        try {
            // オブジェクトを生成。
            conn = new ConnectionImpl("org.hsqldb.jdbcDriver",
                    "jdbc:hsqldb:hsql://localhost", "sa", "");
            Sysdate sysdate = new SysdateImpl("2004-10-20 12:24:30");
            Address address = getAddress();

            // コンポーネントを生成。
            UpdateAddressBook_type2 component = new UpdateAddressBook_type2();

            // オブジェクトを注入。
            component.setConnection(conn);
            component.setSysdate(sysdate);

            // 業務処理を実行。
            Return ret = component.execute(address);

            // 結果を表示。
            System.out.println("result=" + ret.getResult().getName());
            System.out.println("message=" + ret.getMessage());
        } catch (Exception e) {
            // エラー処理。
            if (conn != null) {
                conn.rollback();
            }

            e.printStackTrace();
        } finally {
            // コネクションをクローズ。
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void type3() throws SQLException {
        Connection conn = null;

        try {
            // オブジェクトを生成。
            conn = new ConnectionImpl("org.hsqldb.jdbcDriver",
                    "jdbc:hsqldb:hsql://localhost", "sa", "");
            Sysdate sysdate = new SysdateImpl("2004-10-20 12:24:30");
            Address address = getAddress();

            // コンポーネントを生成。
            UpdateAddressBook_type3 component = new UpdateAddressBook_type3(
                    conn, sysdate);

            // 業務処理を実行。
            Return ret = component.execute(address);

            // 結果を表示。
            System.out.println("result=" + ret.getResult().getName());
            System.out.println("message=" + ret.getMessage());
        } catch (Exception e) {
            // エラー処理。
            if (conn != null) {
                conn.rollback();
            }

            e.printStackTrace();
        } finally {
            // コネクションをクローズ。
            if (conn != null) {
                conn.close();
            }
        }
    }

    private static Address getAddress() {
        Address address = new AddressImpl();
        address.setId("009");
        address.setName("猪川千恵");
        address.setAge(new Integer(25));
        address.setSex(Sex.FEMALE);
        address.setZipCode("3339999");
        address.setAddress("▲▲県■■市■■９－６－３");
        address.setTel("00011112222");
        address.setUpdateDate(new ExDate("2004-07-15 12:13:12"));
        address.setCreateDate(new ExDate("2004-06-10 20:10:30"));
        return address;
    }

}