package bodybuilder.builder;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.util.ObjectUtils;

/**
 * 定数ビルダー
 */
public class ConstBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
        // 子要素は定義できない。
        hasChild = false;
    }

    /**
     * 定数を取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return 定数
     */
    public Object getMuscle(Element element, Argument constructor) {
        // タイプ、名前を取得。
        String type = getRequiredType(element);
        String name = getRequiredName(element);

        // フィールドを返す。
        return ObjectUtils.getFiledValue(type, name);
    }

}