package bodybuilder.inspector;

import java.util.Iterator;
import java.util.Set;

/**
 * ソーテッドセットインスペクター
 */
public class SortedSetInspector extends Inspector {

    /**
     * ソートされた二つのセットが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // セットを取得。
        Set expectedSet = (Set) expected;
        Set actualSet = (Set) actual;
        // セットのサイズを検査。
        assertSizeEquals(expectedSet.size(), actualSet.size(), trace);

        Iterator expectedIte = expectedSet.iterator();
        Iterator actualIte = actualSet.iterator();

        // セットの値を検査。
        for (int i = 0; expectedIte.hasNext(); i++) {
            trace.appendIndex(i);
            Object expectedElement = expectedIte.next();
            Object actualElement = actualIte.next();
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}