package bodybuilder.test;

import java.io.PrintStream;
import junit.framework.TestResult;
import junit.textui.ResultPrinter;

/**
 * 結果プリンタ
 */
public class XMLResultPrinter extends ResultPrinter {

    /**
     * コンストラクタ。
     * 
     * @param printer プリントストリーム
     */
    public XMLResultPrinter(PrintStream printer) {
        super(printer);
    }

    /**
     * テスト結果を出力する。
     * 
     * @param result テスト結果
     * @param runTime 実行時間
     */
    synchronized void print_(TestResult result, long runTime) {
        printHeader(runTime);
        printErrors(result);
        printFailures(result);
        printFooter(result);
    }

}