package bodybuilder.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * サーブレットオブジェクトユーティリティ
 */
public class ServletObjectUtils {

    /**
     * リクエストパラメータを取得する。
     * 
     * @param request リクエスト
     * @return リクエストパラメータ
     */
    public static Map getRequestParameters(HttpServletRequest request) {
        Map params = new HashMap();
        Enumeration names = request.getParameterNames();

        // パラメータのマップを作成。
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            String[] values = request.getParameterValues(name);

            if (values.length == 1) {
                params.put(name, values[0]);
            } else {
                params.put(name, values);
            }
        }

        return params;
    }

    /**
     * リクエストの属性を取得する。
     * 
     * @param request リクエスト
     * @return リクエストの属性
     */
    public static Map getRequestAttributes(HttpServletRequest request) {
        Map attributes = new HashMap();
        Enumeration names = request.getAttributeNames();

        // リクエストの属性のマップを作成。
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            Object value = request.getAttribute(name);
            attributes.put(name, value);
        }

        return attributes;
    }

    /**
     * セッションの属性を取得する。
     * 
     * @param session セッション
     * @return セッションの属性
     */
    public static Map getSessionAttributes(HttpSession session) {
        Map attributes = new HashMap();
        Enumeration names = session.getAttributeNames();

        // セッションの属性のマップを作成。
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            Object value = session.getAttribute(name);
            attributes.put(name, value);
        }

        return attributes;
    }

    /**
     * サーブレットコンテキストの属性を取得する。
     * 
     * @param context サーブレットコンテキスト
     * @return サーブレットコンテキストの属性
     */
    public static Map getServletContextAttributes(ServletContext context) {
        Map attributes = new HashMap();
        Enumeration names = context.getAttributeNames();

        // サーブレットコンテキストの属性のマップを作成。
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            Object value = context.getAttribute(name);
            attributes.put(name, value);
        }

        return attributes;
    }

}