/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder;

import bodybuilder.builder.Builder;
import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.Config;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Bullworker {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder(Config.isValidate());
    private static final String OBJECT_ELEMENT = "object";
    private static final String OBJECT_NAME_ATTRIBUTE = "name";
    private List objectList = new ArrayList();
    private Map objectMap = new HashMap();

    public Bullworker(String filename) {
        this(new File(filename));
    }

    public Bullworker(File file) {
        try {
            this.loadObjects(builder.build(file));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public Bullworker(InputStream in) {
        try {
            this.loadObjects(builder.build(in));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public Bullworker(Reader reader) {
        try {
            this.loadObjects(builder.build(reader));
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public Object getMuscle() {
        if (this.objectList.size() < 1) {
            return null;
        }
        Element object = (Element)this.objectList.get(0);
        return Builder.getValue(object);
    }

    public Object getMuscle(int index) {
        Element object = (Element)this.objectList.get(index);
        return Builder.getValue(object);
    }

    public Object getMuscle(String name) {
        Element object = (Element)this.objectMap.get(name);
        if (object == null) {
            return null;
        }
        return Builder.getValue(object);
    }

    private void loadObjects(Document doc) {
        Element root = doc.getRootElement();
        List children = root.getChildren(OBJECT_ELEMENT);
        for (int i = 0; i < children.size(); ++i) {
            this.add((Element)children.get(i));
        }
    }

    private void add(Element object) {
        this.objectList.add(object);
        String name = object.getAttributeValue(OBJECT_NAME_ATTRIBUTE);
        if (name != null) {
            this.objectMap.put(name, object);
        }
    }
}

