/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test;

import bodybuilder.test.TestCaseMapping;
import bodybuilder.test.XML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.util.FileUtils;
import bodybuilder.util.jdom.JDOMUtils;
import junit.framework.Test;
import org.jdom.Element;

public abstract class TestCaseXML
extends XML {
    protected String name = null;
    protected String description = "";

    public Test getTest() {
        XMLTestCase test = TestCaseMapping.getTestCase(this.xmlType);
        test.setName(this.name);
        test.setXML(this);
        return test;
    }

    protected void build() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(FileUtils.removeExt(this.file.getName()));
        buf.append("]");
        String nameInXml = this.root.getChildTextTrim("name");
        if (nameInXml != null) {
            buf.append(" ");
            buf.append(nameInXml.replace('(', '\uff08').replace(')', '\uff09'));
        }
        this.name = buf.toString();
        this.name = this.name.replace('(', '\uff08').replace(')', '\uff09');
        Element description = this.root.getChild("description");
        if (description != null) {
            this.description = description.getText();
        }
        if (JDOMUtils.getAttrBoolValue(description, "trim")) {
            this.description = this.description.trim();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

