/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test.jsp;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.test.TestCaseXML;
import bodybuilder.test.XMLTestCase;
import bodybuilder.test.jsp.Config;
import bodybuilder.test.jsp.JSPTestCaseXML;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class JSPTestCase
extends XMLTestCase {
    public static final String TESTCASE_XML_PARAM_NAME = "_" + (class$bodybuilder$test$jsp$JSPTestCase == null ? (class$bodybuilder$test$jsp$JSPTestCase = JSPTestCase.class$("bodybuilder.test.jsp.JSPTestCase")) : class$bodybuilder$test$jsp$JSPTestCase).getName() + "_testcase_xml";
    protected JSPTestCaseXML xml = null;
    private static boolean initialize = false;
    static /* synthetic */ Class class$bodybuilder$test$jsp$JSPTestCase;

    protected void setXML(TestCaseXML xml) {
        this.xml = (JSPTestCaseXML)xml;
    }

    protected void runTest() {
        this.info("'" + this.getName() + "' is started .");
        this.debug("description is:" + Config.NL + this.xml.getDescription());
        this.init();
        String contextRoot = Config.getContextRoot();
        this.debug("context root is '" + contextRoot + "'.");
        String path = contextRoot + this.xml.getPath();
        this.debug("request path is '" + path + "'.");
        String charset = Config.getRequestCharset();
        this.debug("request charset is '" + charset + "'.");
        HttpUnitOptions.setDefaultCharacterSet((String)charset);
        HttpUnitOptions.setPostIncludesCharset((boolean)true);
        WebConversation wc = new WebConversation();
        String redirector = contextRoot + Config.getRedirectorPath();
        this.debug("create post method for redirector '" + redirector + "'.");
        PostMethodWebRequest req = new PostMethodWebRequest(redirector);
        this.debug("setup request parameters.");
        Map params = this.xml.getParama();
        Iterator names = params.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String[] values = (String[])params.get(name);
            if (values.length == 1) {
                this.debug("add patameter '" + name + "'(" + values[0] + ").");
            } else {
                this.debug("add patameter '" + name + "'(" + Arrays.asList(values) + ").");
            }
            req.setParameter(name, values);
        }
        this.debug("set testcase xml to patameter");
        req.setParameter(TESTCASE_XML_PARAM_NAME, this.xml.getFile().getAbsolutePath());
        this.debug("request to '" + redirector + "'.");
        WebResponse res = null;
        try {
            res = wc.getResponse((WebRequest)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BodyBuilderException("it was not able to request '" + redirector + "'.", e);
        }
        String output = this.xml.getOutput();
        this.debug("output is '" + output + "'.");
        String resText = null;
        try {
            resText = res.getText();
        }
        catch (IOException e) {
            throw new BodyBuilderException("cannot get response text.", e);
        }
        this.debug("response text is:" + Config.NL + resText);
        this.debug("output file.");
        try {
            FileWriter writer = new FileWriter(output);
            writer.write(resText);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new BodyBuilderException("cannot output file.", e);
        }
        this.info("test was ended.");
    }

    private void init() {
        if (initialize) {
            return;
        }
        String path = Config.getInitRequestPath();
        this.debug("init request path is '" + path + "'.");
        if (path == null) {
            return;
        }
        this.debug("initialize request.");
        WebConversation wc = new WebConversation();
        GetMethodWebRequest req = new GetMethodWebRequest(path);
        try {
            wc.getResponse((WebRequest)req);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BodyBuilderException("it was not able to initialize request '" + path + "'.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

