/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util.dbunit;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.util.dbunit.JxlDataSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.SortedDataSet;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DbUnitUtils {
    private static Class driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$XmlDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$FlatXmlDataSet;
    static /* synthetic */ Class class$org$dbunit$dataset$excel$XlsDataSet;

    public static void registerDriver(String driverName) {
        try {
            if (driver == null) {
                driver = Class.forName(driverName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new BodyBuilderException(e);
        }
    }

    public DbUnitUtils(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    private IDatabaseConnection getConnection() {
        try {
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            return new DatabaseConnection(conn);
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
    }

    private void close(IDatabaseConnection iconn) {
        if (iconn == null) {
            return;
        }
        try {
            iconn.close();
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
    }

    public void setUpDatabase(String filename, String type) {
        IDatabaseConnection conn = null;
        try {
            conn = this.getConnection();
            IDataSet data = this.getDataSet(filename, type);
            DatabaseOperation.CLEAN_INSERT.execute(conn, data);
        }
        catch (DatabaseUnitException e) {
            throw new BodyBuilderException(e);
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
        finally {
            this.close(conn);
        }
    }

    public void assertDataSetEquals(String filename, String type, Map ignore) {
        IDatabaseConnection conn = null;
        try {
            conn = this.getConnection();
            IDataSet expectedDataSet = this.getDataSet(filename, type);
            IDataSet actualDataSet = conn.createDataSet();
            String[] names = expectedDataSet.getTableNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                ITable expectedTable = expectedDataSet.getTable(name);
                ITable actualTable = actualDataSet.getTable(name);
                String[] columns = ignore != null ? ignore.get(name.toUpperCase()) : null;
                this.assertTableEquals(expectedTable, actualTable, columns);
            }
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        finally {
            this.close(conn);
        }
    }

    public void assertTableEquals(ITable expected, ITable actual, String[] ignore) {
        IDatabaseConnection conn = null;
        try {
            conn = this.getConnection();
            if (ignore != null && ignore.length > 0) {
                expected = this.getFilteredTable(expected, ignore);
                actual = this.getFilteredTable(actual, ignore);
            }
            if (expected.getRowCount() == 0 && actual.getRowCount() == 0) {
                return;
            }
            expected = new SortedTable(expected);
            actual = new SortedTable(actual);
            Assertion.assertEquals((ITable)expected, (ITable)actual);
        }
        catch (DatabaseUnitException e) {
            throw new BodyBuilderException(e);
        }
        finally {
            this.close(conn);
        }
    }

    private ITable getFilteredTable(ITable table, String[] ignore) {
        try {
            return DefaultColumnFilter.excludedColumnsTable((ITable)table, (String[])ignore);
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
    }

    private IDataSet getDataSet(String filename, String type) {
        if ((class$org$dbunit$dataset$xml$XmlDataSet == null ? (class$org$dbunit$dataset$xml$XmlDataSet = DbUnitUtils.class$("org.dbunit.dataset.xml.XmlDataSet")) : class$org$dbunit$dataset$xml$XmlDataSet).getName().equals(type)) {
            return this.getXmlDataSet(filename);
        }
        if ((class$org$dbunit$dataset$xml$FlatXmlDataSet == null ? (class$org$dbunit$dataset$xml$FlatXmlDataSet = DbUnitUtils.class$("org.dbunit.dataset.xml.FlatXmlDataSet")) : class$org$dbunit$dataset$xml$FlatXmlDataSet).getName().equals(type)) {
            return this.getFlatXmlDataSet(filename);
        }
        if ((class$org$dbunit$dataset$excel$XlsDataSet == null ? (class$org$dbunit$dataset$excel$XlsDataSet = DbUnitUtils.class$("org.dbunit.dataset.excel.XlsDataSet")) : class$org$dbunit$dataset$excel$XlsDataSet).getName().equals(type)) {
            return this.getXlsDataSet(filename);
        }
        throw new BodyBuilderException("unimplemented dataset '" + type + "'.");
    }

    private XmlDataSet getXmlDataSet(String filename) {
        try {
            return new XmlDataSet((InputStream)new FileInputStream(filename));
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    private FlatXmlDataSet getFlatXmlDataSet(String filename) {
        try {
            return new FlatXmlDataSet(new File(filename));
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    private JxlDataSet getXlsDataSet(String filename) {
        try {
            return new JxlDataSet(new File(filename));
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public String getDatabaseContent() {
        IDatabaseConnection conn = null;
        try {
            conn = this.getConnection();
            IDataSet dataSet = conn.createDataSet();
            StringWriter writer = new StringWriter();
            FlatXmlDataSet.write((IDataSet)new SortedDataSet(dataSet), (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
        finally {
            this.close(conn);
        }
    }

    public String getTableContent(String name) {
        IDatabaseConnection conn = null;
        try {
            conn = this.getConnection();
            IDataSet dataSet = conn.createDataSet(new String[]{name});
            StringWriter writer = new StringWriter();
            FlatXmlDataSet.write((IDataSet)new SortedDataSet(dataSet), (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (SQLException e) {
            throw new BodyBuilderException(e);
        }
        catch (DataSetException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
        finally {
            this.close(conn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

