package bodybuilder.ant.xmltest;

import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;

/**
 * 拡張フォーマッタ要素
 */
public class ExtendedFormatterElement extends FormatterElement {

    /**
     * タイプをセットする。
     * 
     * @param type タイプ
     */
    public void setType(FormatterElement.TypeAttribute type) {
        if ("xml".equals(type.getValue())) {
            // 「xml」の場合は拡張XMLJUnitフォーマッタをセット。
            setClassname(ExtendedXMLJUnitResultFormatter.class.getName());
        } else {
            // それ以外の場合はオーバーライドしたメソッドを呼び出す。
            super.setType(type);
        }
    }

    /**
     * クラス名をセットする。
     * 
     * @param classname クラス名
     */
    public void setClassname(String classname) {
        // 拡張XMLJUnitフォーマッタの場合は拡張子「.xml」をセット。
        if (ExtendedXMLJUnitResultFormatter.class.getName().equals(classname)) {
            setExtension(".xml");
        }

        // オーバーライドしたメソッドを呼び出す。
        super.setClassname(classname);
    }

}