package bodybuilder.builder;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;

/**
 * リストビルダー
 */
public class ListBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "add";

    /**
     * リストを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return リスト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // リストを生成。
        // デフォルトの実装はArrayListクラス。
        String type = getType(element, ArrayList.class.getName());
        List list = (List) newObject(type, constructor);

        // <add>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <add>の値をリストに格納。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            Object value = getValue(child);
            list.add(value);
        }

        // リストを返す。
        return list;
    }

}