package bodybuilder.builder.servlet;

import java.util.List;

import javax.servlet.ServletContext;

import org.jdom.Element;

import com.mockrunner.mock.web.MockServletContext;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * サーブレットコンテキストビルダー
 */
public class ServletContextBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * サーブレットコンテキストを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return サーブレットコンテキスト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックサーブレットコンテキストを生成。
        MockServletContext context = new MockServletContext();
        // サーブレットコンテキストをセットアップ。
        setup(element, context);
        // サーブレットコンテキストを返す。
        return context;
    }

    /**
     * サーブレットコンテキストをセットアップする。
     * 
     * @param element XML要素
     * @param context サーブレットコンテキスト
     */
    public static void setup(Element element, ServletContext context) {
        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をサーブレットコンテキストにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            context.setAttribute(name, value);
        }
    }

}