package bodybuilder.inspector;

import java.util.List;

/**
 * リストインスペクター
 */
public class ListInspector extends Inspector {

    /**
     * 二つのリストが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // リストを取得。
        List expectedList = (List) expected;
        List actualList = (List) actual;
        // リストのサイズを検査。
        assertSizeEquals(expectedList.size(), actualList.size(), trace);

        // リストの値を検査。
        for (int i = 0; i < expectedList.size(); i++) {
            trace.appendIndex(i);
            Object expectedElement = expectedList.get(i);
            Object actualElement = actualList.get(i);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}