package bodybuilder.viewer.handler;

import java.io.PrintWriter;

/**
 * 抽象出力ハンドラ
 */
public abstract class AbstractOutputHandler implements OutputHandler {

    /**
     * プリントライタ
     */
    protected PrintWriter printWriter = null;

    /**
     * タブ
     */
    protected String tab = null;

    /**
     * ネストレベル
     */
    private int level = 0;

    /**
     * インデントする。
     */
    public void indent() {
        level++;
    }

    /**
     * アンインデントする。
     */
    public void unindent() {
        level--;
    }

    /**
     * 出力する。
     * 
     * @param str 文字列
     */
    public void print(String str) {
        printIndent();
        printWriter.println(str);
    }

    /**
     * インデントを出力する。
     */
    private void printIndent() {
        for (int i = 0; i < level; i++) {
            printWriter.print(tab);
        }
    }

}