/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.test;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.test.TestCaseMapping;
import bodybuilder.util.jdom.ExtendedSAXBuilder;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class XML {
    private static final ExtendedSAXBuilder builder = new ExtendedSAXBuilder();
    protected Element root = null;
    protected String xmlType = null;
    protected File file = null;

    public static XML newXML(String filename) {
        return XML.newXML(new File(filename));
    }

    public static XML newXML(File file) {
        try {
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            return XML.newXML(file, root);
        }
        catch (JDOMException e) {
            throw new BodyBuilderException(e);
        }
        catch (IOException e) {
            throw new BodyBuilderException(e);
        }
    }

    public static XML newXML(File file, Element root) {
        String type = root.getName();
        XML xml = TestCaseMapping.getXML(type);
        xml.file = file;
        xml.root = root;
        xml.xmlType = type;
        xml.build();
        return xml;
    }

    public abstract Test getTest();

    protected abstract void build();

    public File getFile() {
        return this.file;
    }

    public Element getRoot() {
        return this.root;
    }

    public String getXmlType() {
        return this.xmlType;
    }
}

