package bodybuilder.builder;

import java.util.List;
import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.argument.ArgumentBuilder;
import bodybuilder.util.ObjectUtils;

/**
 * クラスビルダー
 */
public class ClassBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "exec";

    /**
     * クラスのインスタンスを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return クラスのインスタンス
     */
    public Object getMuscle(Element element, Argument constructor) {
        // オブジェクトを生成。
        String type = getRequiredType(element);
        Object object = newObject(type, constructor);

        // <exec>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <exec>に定義されたメソッドを実行。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            String name = getRequiredName(child);
            Argument argument = ArgumentBuilder.getArgument(child);
            ObjectUtils.invokeMethod(object, name, argument.getClasses(),
                    argument.getArguments(), argument.isFuzzy());
        }

        // オブジェクトを返す。
        return object;
    }

}