package bodybuilder.builder;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

import bodybuilder.builder.argument.Argument;

/**
 * セットビルダー
 */
public class SetBuilder extends Builder {

    /**
     * メソッド名
     */
    private static final String METHOD_NAME = "add";

    /**
     * セットを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return セット
     */
    public Object getMuscle(Element element, Argument constructor) {
        // セットを生成。
        // デフォルトの実装はLinkedHashSetクラス。
        String type = getType(element, LinkedHashSet.class.getName());
        Set set = (Set) newObject(type, constructor);

        // <add>を取得。
        List children = element.getChildren(METHOD_NAME);

        // <add>の値をSetに格納。
        for (int i = 0; i < children.size(); i++) {
            Element child = (Element) children.get(i);
            Object value = getValue(child);
            set.add(value);
        }

        // セットを返す。
        return set;
    }

}