package bodybuilder.builder.value;

import bodybuilder.exception.BodyBuilderException;

/**
 * プリミティブラッパー値
 */
public class PrimitiveWrapperValue extends ExtendedValue {

    /**
     * プリミティブラッパーを取得する。
     * 
     * @param value 拡張値
     * @return プリミティブラッパー
     */
    protected Object value(String value) {
        int pos = value.indexOf(':');
        String head = value.substring(0, pos);
        String val = value.substring(pos + 1);
        Object obj = null;

        if ("Z".equals(head)) {
            obj = Boolean.valueOf(val);
        } else if ("B".equals(head)) {
            obj = Byte.valueOf(val);
        } else if ("C".equals(head)) {
            obj = new Character((char) Integer.parseInt(val));
        } else if ("S".equals(head)) {
            obj = Short.valueOf(val);
        } else if ("I".equals(head)) {
            obj = Integer.valueOf(val);
        } else if ("J".equals(head)) {
            obj = Long.valueOf(val);
        } else if ("F".equals(head)) {
            obj = Float.valueOf(val);
        } else if ("D".equals(head)) {
            obj = Double.valueOf(val);
        } else {
            throw new BodyBuilderException(
                    "cannot create primitive wrapper value by '" + value + "'");
        }

        return obj;
    }

}