package bodybuilder.inspector;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日付インスペクター
 */
public class DateInspector extends Inspector {

    /**
     * 二つの日付オブジェクトが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // 日付オブジェクトを取得。
        Date expectedDate = (Date) expected;
        Date actualDate = (Date) actual;

        // 日付を比較。
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        assertObjectEquals(df.format(expectedDate), df.format(actualDate),
                trace);
    }

}